﻿/*
 * Globalize Culture zh
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo("zh", "default", {
    name: "zh",
	englishName: "Chinese",
	nativeName: "中文",
	isRTL: false,
	language: "zh",
	numberFormat: {
		currency: {
		    pattern: ["$-n", "$n"],
		    symbol: "¥"
		}
	},
	calendars: {
	    standard: {
	        "/": "-",
	        firstDay: 1,
            days: {
				// full day names
				names: [ "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六" ],
				// abbreviated day names
				namesAbbr: [ "周日", "周一", "周二", "周三", "周四", "周五", "周六" ],
				// shortest day names
				namesShort: [ "日", "一", "二", "三", "四", "五", "六" ]
			},
			months: {
				// full month names (13 months for lunar calendards -- 13th month should be "" if not lunar)
				names: [ "一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月", "" ],
				// abbreviated month names
				namesAbbr: [ "1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月", "" ]
			},
			AM: null,
			PM: null,
			patterns: {
			    d: "yyyy/M/d",
			    D: "yyyy年M月d日,dddd",
				t: "H:mm",
				T: "H:mm:ss",
				f: "yyyy年M月d日,dddd H:mm",
				F: "yyyy年M月d日,dddd H:mm:ss",
				M: "M月d日",
				Y: "yyyy年M月"
			}
		}
	}
});

}( this ));